/*
 * Decompiled with CFR 0.152.
 */
package org.watermedia.videolan4j.media;

import org.watermedia.videolan4j.binding.internal.libvlc_instance_t;
import org.watermedia.videolan4j.binding.internal.libvlc_media_t;
import org.watermedia.videolan4j.binding.lib.LibVlc;
import org.watermedia.videolan4j.media.EventApi;
import org.watermedia.videolan4j.media.InfoApi;
import org.watermedia.videolan4j.media.MediaRef;
import org.watermedia.videolan4j.media.MetaApi;
import org.watermedia.videolan4j.media.OptionsApi;
import org.watermedia.videolan4j.media.ParseApi;
import org.watermedia.videolan4j.media.SlaveApi;
import org.watermedia.videolan4j.media.SubitemApi;

public final class Media {
    protected final libvlc_instance_t libvlcInstance;
    protected final libvlc_media_t mediaInstance;
    private final EventApi eventApi;
    private final InfoApi infoApi;
    private final MetaApi metaApi;
    private final OptionsApi optionsApi;
    private final ParseApi parseApi;
    private final SlaveApi slaveApi;
    private final SubitemApi subitemApi;

    public Media(libvlc_instance_t libvlcInstance, libvlc_media_t media) {
        this.libvlcInstance = libvlcInstance;
        this.mediaInstance = media;
        this.eventApi = new EventApi(this);
        this.infoApi = new InfoApi(this);
        this.metaApi = new MetaApi(this);
        this.optionsApi = new OptionsApi(this);
        this.parseApi = new ParseApi(this);
        this.slaveApi = new SlaveApi(this);
        this.subitemApi = new SubitemApi(this);
    }

    public EventApi events() {
        return this.eventApi;
    }

    public InfoApi info() {
        return this.infoApi;
    }

    public MetaApi meta() {
        return this.metaApi;
    }

    public OptionsApi options() {
        return this.optionsApi;
    }

    public ParseApi parsing() {
        return this.parseApi;
    }

    public SlaveApi slaves() {
        return this.slaveApi;
    }

    public SubitemApi subitems() {
        return this.subitemApi;
    }

    public MediaRef newMediaRef() {
        LibVlc.libvlc_media_retain(this.mediaInstance);
        return new MediaRef(this.libvlcInstance, this.mediaInstance);
    }

    public Media newMedia() {
        LibVlc.libvlc_media_retain(this.mediaInstance);
        return new Media(this.libvlcInstance, this.mediaInstance);
    }

    public MediaRef duplicateMediaRef() {
        return new MediaRef(this.libvlcInstance, LibVlc.libvlc_media_duplicate(this.mediaInstance));
    }

    public Media duplicateMedia() {
        return new Media(this.libvlcInstance, LibVlc.libvlc_media_duplicate(this.mediaInstance));
    }

    public void release() {
        this.eventApi.release();
        this.infoApi.release();
        this.optionsApi.release();
        this.parseApi.release();
        this.metaApi.release();
        this.slaveApi.release();
        this.subitemApi.release();
        LibVlc.libvlc_media_release(this.mediaInstance);
    }

    public libvlc_media_t mediaInstance() {
        return this.mediaInstance;
    }
}

